import { EntityEquippableComponent, EquipmentSlot, GameMode, ItemDurabilityComponent, ItemStack, Player, world } from "@minecraft/server";
export class PlayerUtils {
    static damageMainhandItemStack(player, ignoreItemUpdate = false, amount = 1, applyOnCreativeMode = false) {
      if (!player) return undefined;
      const equippable = player.getComponent(EntityEquippableComponent.componentId);
      const stack = equippable.getEquipment(EquipmentSlot.Mainhand);
      const durability = stack.getComponent(ItemDurabilityComponent.componentId);
      if (!durability) {
        throw new Error(`The item ${stack.typeId} don't have ${ItemDurabilityComponent.componentId} component.`);
      }
      if (!durability.damage) {
        durability.damage = 0;
      }
      const newDamage = durability.damage + amount;
      if (newDamage >= durability.maxDurability && !ignoreItemUpdate) {
        equippable.setEquipment(EquipmentSlot.Mainhand, undefined);
        world.playSound("random.break", player.location);
        return newDamage;
      }
      if (player.getGameMode() === GameMode.creative && !applyOnCreativeMode) return durability.damage;
      if (!ignoreItemUpdate) {
        const updatedStack = new ItemStack(stack.typeId);
        const updatedStackDurability = updatedStack.getComponent(ItemDurabilityComponent.componentId);
        updatedStackDurability.damage = newDamage;
        equippable.setEquipment(EquipmentSlot.Mainhand, updatedStack);
      }
      return newDamage;
    }
}